# Collect hardware information for aarch64 systems
class SUSE::Connect::HwInfo::ARM64 < SUSE::Connect::HwInfo::Base
  class << self
    def hwinfo
      {
        hostname: hostname,
        cpus: cpus,
        sockets: sockets,
        hypervisor: hypervisor,
        arch: arch,
        uuid: uuid,
        cloud_provider: cloud_provider
      }
    end

    def cpus
      output['CPU(s)'].to_i
    end

    def sockets
      output['Socket(s)'].to_i
    end

    def hypervisor
      vendor = execute('systemd-detect-virt -v', false, [0, 1])
      vendor == 'none' ? nil : vendor
    end

    def uuid
      if File.exist?('/sys/hypervisor/uuid')
        # INFO: bnc#890881 read the uuid generated by the hypervisor (SLES for EC2)
        File.read('/sys/hypervisor/uuid').chomp
      else
        uuid_output = execute('dmidecode -s system-uuid', false)
        ['Not Settable', 'Not Present'].include?(uuid_output) ? nil : uuid_output
      end
    rescue
      nil
    end

    def output
      @output ||= execute('lscpu', false).split("\n").each_with_object({}) do |line, hash|
        k, v = line.split(':')
        hash[k] = v.strip if v
      end
    end
  end
end
